"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGridRowAriaAttributes = void 0;
var React = _interopRequireWildcard(require("react"));
var _useGridSelector = require("../../utils/useGridSelector");
var _gridColumnGroupsSelector = require("../columnGrouping/gridColumnGroupsSelector");
var _useGridPrivateApiContext = require("../../utils/useGridPrivateApiContext");
const useGridRowAriaAttributes = () => {
  const apiRef = (0, _useGridPrivateApiContext.useGridPrivateApiContext)();
  const headerGroupingMaxDepth = (0, _useGridSelector.useGridSelector)(apiRef, _gridColumnGroupsSelector.gridColumnGroupsHeaderMaxDepthSelector);
  return React.useCallback((rowNode, index) => {
    const ariaAttributes = {};
    const ariaRowIndex = index + headerGroupingMaxDepth + 2; // 1 for the header row and 1 as it's 1-based
    ariaAttributes['aria-rowindex'] = ariaRowIndex;
    if (apiRef.current.isRowSelectable(rowNode.id)) {
      ariaAttributes['aria-selected'] = apiRef.current.isRowSelected(rowNode.id);
    }
    return ariaAttributes;
  }, [apiRef, headerGroupingMaxDepth]);
};
exports.useGridRowAriaAttributes = useGridRowAriaAttributes;